﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.CompilerServices;
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace Managed_Hook
{
    public class KeyboardHook
    {
        //**************************Variablen und Delegaten****************
        #region Variablen, Events und Delegaten
        private delegate void HookProcessedHandler(int code, UIntPtr wparam, IntPtr lparam);
        public delegate void KeyboardEventHandler(KeyboardEvents kEvent, Keys key);

        private HookProcessedHandler ProcessedHandler = null;
        private bool b_hooked = false;

        public event KeyboardEventHandler KeyboardEvent;
        #endregion
        //************************GET SET START*************************
        #region GET SET
        public bool bhooked
        {
            get
            {
                return b_hooked;
            }
        }
        #endregion
        //************************METHODEN*************************
        #region Methoden
        /// <summary>
        /// Construktor
        /// </summary>          
        public KeyboardHook()
        {
            ProcessedHandler = new HookProcessedHandler(InternalHookCallback);
            SetCallBackResults result = SetUserHookCallback(ProcessedHandler, HookTypes.KeyboardLL);
            if (result != SetCallBackResults.Gelungen)
            {
                this.dispose(); //Hook Deinstallieren und Instanze der Klasse vernichten
            }

        }

        private void HookCallback(int code, UIntPtr wparam, IntPtr lparam)
        {
            if (KeyboardEvent == null)
            {
                return;
            }

            int vkCode = 0;
            KeyboardEvents kEvent = (KeyboardEvents)wparam.ToUInt32();

            if (kEvent != KeyboardEvents.KeyDown &&
                kEvent != KeyboardEvents.KeyUp &&
                kEvent != KeyboardEvents.SystemKeyDown &&
                kEvent != KeyboardEvents.SystemKeyUp)
            {
                return;
            }

            GetKeyboardReading(wparam, lparam, ref vkCode);
            VirtualKeys vk = (VirtualKeys)vkCode;

            Keys key = ConvertKeyCode(vk);

            if (key == Keys.Attn)
            {
                return;
            }

            KeyboardEvent(kEvent, key);
        }

        [MethodImpl(MethodImplOptions.NoInlining)]
        private void InternalHookCallback(int code, UIntPtr wparam, IntPtr lparam)
        {
            try
            {
                HookCallback(code, wparam, lparam);
            }
            catch (Exception e)
            {
                Debug.WriteLine("Exception wärend der hook callback: " + e.Message + " " + e.ToString());
            }
        }
        public void Install()//hook setzen
        {
            if (!InitializeHook(HookTypes.KeyboardLL, 0))
            {
                //fehler
            }
            b_hooked = true;
        }

        public void Uninstall()
        {
            b_hooked = false;
            UninitializeHook(HookTypes.KeyboardLL);
        }
        public void dispose()
        {
            GC.SuppressFinalize(this);
            Uninstall();
        }

        protected void GetKeyboardReading(UIntPtr wparam, IntPtr lparam, ref int vkCode)
        {
            if (!IntenralGetKeyboardReading(wparam, lparam, ref vkCode))
            {
                //Fehler
            }
        }
        private Keys ConvertKeyCode(VirtualKeys vk)
        {
            Keys key = Keys.Attn;

            switch (vk)
            {
                case VirtualKeys.ShiftLeft:
                    key = Keys.Shift;
                    break;
                case VirtualKeys.ShiftRight:
                    key = Keys.Shift;
                    break;
                case VirtualKeys.ControlLeft:
                    key = Keys.Control;
                    break;
                case VirtualKeys.ControlRight:
                    key = Keys.Control;
                    break;
                case VirtualKeys.AltLeft:
                    key = Keys.Alt;
                    break;
                case VirtualKeys.AltRight:
                    key = Keys.Alt;
                    break;
                case VirtualKeys.Back:
                    key = Keys.Back;
                    break;
                case VirtualKeys.Tab:
                    key = Keys.Tab;
                    break;
                case VirtualKeys.Clear:
                    key = Keys.Clear;
                    break;
                case VirtualKeys.Return:
                    key = Keys.Return;
                    break;
                case VirtualKeys.Menu:
                    key = Keys.Menu;
                    break;
                case VirtualKeys.Pause:
                    key = Keys.Pause;
                    break;
                case VirtualKeys.Capital:
                    key = Keys.Capital;
                    break;
                case VirtualKeys.Escape:
                    key = Keys.Escape;
                    break;
                case VirtualKeys.Space:
                    key = Keys.Space;
                    break;
                case VirtualKeys.Prior:
                    key = Keys.Prior;
                    break;
                case VirtualKeys.Next:
                    key = Keys.Next;
                    break;
                case VirtualKeys.End:
                    key = Keys.End;
                    break;
                case VirtualKeys.Home:
                    key = Keys.Home;
                    break;
                case VirtualKeys.Left:
                    key = Keys.Left;
                    break;
                case VirtualKeys.Up:
                    key = Keys.Up;
                    break;
                case VirtualKeys.Right:
                    key = Keys.Right;
                    break;
                case VirtualKeys.Down:
                    key = Keys.Down;
                    break;
                case VirtualKeys.Select:
                    key = Keys.Select;
                    break;
                case VirtualKeys.Print:
                    key = Keys.Print;
                    break;
                case VirtualKeys.Execute:
                    key = Keys.Execute;
                    break;
                case VirtualKeys.Snapshot:
                    key = Keys.Snapshot;
                    break;
                case VirtualKeys.Insert:
                    key = Keys.Insert;
                    break;
                case VirtualKeys.Delete:
                    key = Keys.Delete;
                    break;
                case VirtualKeys.Help:
                    key = Keys.Help;
                    break;
                case VirtualKeys.D0:
                    key = Keys.D0;
                    break;
                case VirtualKeys.D1:
                    key = Keys.D1;
                    break;
                case VirtualKeys.D2:
                    key = Keys.D2;
                    break;
                case VirtualKeys.D3:
                    key = Keys.D3;
                    break;
                case VirtualKeys.D4:
                    key = Keys.D4;
                    break;
                case VirtualKeys.D5:
                    key = Keys.D5;
                    break;
                case VirtualKeys.D6:
                    key = Keys.D6;
                    break;
                case VirtualKeys.D7:
                    key = Keys.D7;
                    break;
                case VirtualKeys.D8:
                    key = Keys.D8;
                    break;
                case VirtualKeys.D9:
                    key = Keys.D9;
                    break;
                case VirtualKeys.A:
                    key = Keys.A;
                    break;
                case VirtualKeys.B:
                    key = Keys.B;
                    break;
                case VirtualKeys.C:
                    key = Keys.C;
                    break;
                case VirtualKeys.D:
                    key = Keys.D;
                    break;
                case VirtualKeys.E:
                    key = Keys.E;
                    break;
                case VirtualKeys.F:
                    key = Keys.F;
                    break;
                case VirtualKeys.G:
                    key = Keys.G;
                    break;
                case VirtualKeys.H:
                    key = Keys.H;
                    break;
                case VirtualKeys.I:
                    key = Keys.I;
                    break;
                case VirtualKeys.J:
                    key = Keys.J;
                    break;
                case VirtualKeys.K:
                    key = Keys.K;
                    break;
                case VirtualKeys.L:
                    key = Keys.L;
                    break;
                case VirtualKeys.M:
                    key = Keys.M;
                    break;
                case VirtualKeys.N:
                    key = Keys.N;
                    break;
                case VirtualKeys.O:
                    key = Keys.O;
                    break;
                case VirtualKeys.P:
                    key = Keys.P;
                    break;
                case VirtualKeys.Q:
                    key = Keys.Q;
                    break;
                case VirtualKeys.R:
                    key = Keys.R;
                    break;
                case VirtualKeys.S:
                    key = Keys.S;
                    break;
                case VirtualKeys.T:
                    key = Keys.T;
                    break;
                case VirtualKeys.U:
                    key = Keys.U;
                    break;
                case VirtualKeys.V:
                    key = Keys.V;
                    break;
                case VirtualKeys.W:
                    key = Keys.W;
                    break;
                case VirtualKeys.X:
                    key = Keys.X;
                    break;
                case VirtualKeys.Y:
                    key = Keys.Y;
                    break;
                case VirtualKeys.Z:
                    key = Keys.Z;
                    break;
                case VirtualKeys.LWindows:
                    key = Keys.LWin;
                    break;
                case VirtualKeys.RWindows:
                    key = Keys.RWin;
                    break;
                case VirtualKeys.Apps:
                    key = Keys.Apps;
                    break;
                case VirtualKeys.NumPad0:
                    key = Keys.NumPad0;
                    break;
                case VirtualKeys.NumPad1:
                    key = Keys.NumPad1;
                    break;
                case VirtualKeys.NumPad2:
                    key = Keys.NumPad2;
                    break;
                case VirtualKeys.NumPad3:
                    key = Keys.NumPad3;
                    break;
                case VirtualKeys.NumPad4:
                    key = Keys.NumPad4;
                    break;
                case VirtualKeys.NumPad5:
                    key = Keys.NumPad5;
                    break;
                case VirtualKeys.NumPad6:
                    key = Keys.NumPad6;
                    break;
                case VirtualKeys.NumPad7:
                    key = Keys.NumPad7;
                    break;
                case VirtualKeys.NumPad8:
                    key = Keys.NumPad8;
                    break;
                case VirtualKeys.NumPad9:
                    key = Keys.NumPad9;
                    break;
                case VirtualKeys.Multiply:
                    key = Keys.Multiply;
                    break;
                case VirtualKeys.Add:
                    key = Keys.Add;
                    break;
                case VirtualKeys.Separator:
                    key = Keys.Separator;
                    break;
                case VirtualKeys.Subtract:
                    key = Keys.Subtract;
                    break;
                case VirtualKeys.Decimal:
                    key = Keys.Decimal;
                    break;
                case VirtualKeys.Divide:
                    key = Keys.Divide;
                    break;
                case VirtualKeys.F1:
                    key = Keys.F1;
                    break;
                case VirtualKeys.F2:
                    key = Keys.F2;
                    break;
                case VirtualKeys.F3:
                    key = Keys.F3;
                    break;
                case VirtualKeys.F4:
                    key = Keys.F4;
                    break;
                case VirtualKeys.F5:
                    key = Keys.F5;
                    break;
                case VirtualKeys.F6:
                    key = Keys.F6;
                    break;
                case VirtualKeys.F7:
                    key = Keys.F7;
                    break;
                case VirtualKeys.F8:
                    key = Keys.F8;
                    break;
                case VirtualKeys.F9:
                    key = Keys.F9;
                    break;
                case VirtualKeys.F10:
                    key = Keys.F10;
                    break;
                case VirtualKeys.F11:
                    key = Keys.F11;
                    break;
                case VirtualKeys.F12:
                    key = Keys.F12;
                    break;
                case VirtualKeys.F13:
                    key = Keys.F13;
                    break;
                case VirtualKeys.F14:
                    key = Keys.F14;
                    break;
                case VirtualKeys.F15:
                    key = Keys.F15;
                    break;
                case VirtualKeys.F16:
                    key = Keys.F16;
                    break;
                case VirtualKeys.F17:
                    key = Keys.F17;
                    break;
                case VirtualKeys.F18:
                    key = Keys.F18;
                    break;
                case VirtualKeys.F19:
                    key = Keys.F19;
                    break;
                case VirtualKeys.F20:
                    key = Keys.F20;
                    break;
                case VirtualKeys.F21:
                    key = Keys.F21;
                    break;
                case VirtualKeys.F22:
                    key = Keys.F22;
                    break;
                case VirtualKeys.F23:
                    key = Keys.F23;
                    break;
                case VirtualKeys.F24:
                    key = Keys.F24;
                    break;
                case VirtualKeys.NumLock:
                    key = Keys.NumLock;
                    break;
                case VirtualKeys.Scroll:
                    key = Keys.Scroll;
                    break;
            }

            return key;
        }
        #endregion

        #region Imported Static Methods for SystemHookCore.dll

        [DllImport("SystemHookCore.dll", EntryPoint = "SetUserHookCallback", SetLastError = true,
             CharSet = CharSet.Unicode, ExactSpelling = true,
             CallingConvention = CallingConvention.StdCall)]
        private static extern SetCallBackResults SetUserHookCallback(HookProcessedHandler hookCallback, HookTypes hookType);

        [DllImport("SystemHookCore.dll", EntryPoint = "InitializeHook", SetLastError = true,
             CharSet = CharSet.Unicode, ExactSpelling = true,
             CallingConvention = CallingConvention.StdCall)]
        private static extern bool InitializeHook(HookTypes hookType, int threadID);

        [DllImport("SystemHookCore.dll", EntryPoint = "UninitializeHook", SetLastError = true,
             CharSet = CharSet.Unicode, ExactSpelling = true,
             CallingConvention = CallingConvention.StdCall)]
        private static extern void UninitializeHook(HookTypes hookType);

        [DllImport("SystemHookCore.dll", EntryPoint = "GetKeyboardReading", SetLastError = true,
             CharSet = CharSet.Unicode, ExactSpelling = true,
             CallingConvention = CallingConvention.StdCall)]
        private static extern bool IntenralGetKeyboardReading(UIntPtr wparam, IntPtr lparam, ref int vkCode);

        [DllImport("SystemHookCore.dll", EntryPoint = "Dispose", SetLastError = true,
             CharSet = CharSet.Unicode, ExactSpelling = true,
             CallingConvention = CallingConvention.StdCall)]
        private static extern void DisposeCppLayer(HookTypes hookType);

        [DllImport("SystemHookCore.dll", EntryPoint = "FilterMessage", SetLastError = true,
             CharSet = CharSet.Unicode, ExactSpelling = true,
             CallingConvention = CallingConvention.StdCall)]
        private static extern FilterMessageResults InternalFilterMessage(HookTypes hookType, int message);

        #endregion
    }
}